/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;

public class SelectionBox
extends Component
implements ComponentListener {
    private static Color selectionBorderColor;
    private int selectionBorderThickness;
    private Component comp;
    private boolean hidden = false;
    private boolean uninitialized = true;

    public void initFor(Component component, Container container, int n) {
        this.selectionBorderThickness = n;
        this.comp = component;
        this.sizeTo(component, container);
    }

    private void sizeTo(Component component, Container container) {
        Dimension dimension = component.getSize();
        dimension.height += 2 * this.selectionBorderThickness;
        dimension.width += 2 * this.selectionBorderThickness;
        try {
            Point point = component.getLocationOnScreen();
            Point point2 = container.getLocationOnScreen();
            int n = point.x - point2.x - this.selectionBorderThickness;
            int n2 = point.y - point2.y - this.selectionBorderThickness;
            this.setBounds(n, n2, dimension.width, dimension.height);
            this.uninitialized = false;
            return;
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            this.setHidden(true);
            this.uninitialized = true;
            return;
        }
    }

    private void setHidden(boolean bl) {
        if (this.hidden != bl) {
            this.hidden = bl;
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        if (!this.comp.isShowing()) {
            this.setHidden(true);
            return;
        }
        if (this.hidden) {
            this.setHidden(false);
            return;
        }
        super.paint(graphics);
        Dimension dimension = this.getSize();
        graphics.setColor(this.getSelectionBorderColor());
        int n = 0;
        int n2 = 0;
        int n3 = dimension.width - 1;
        int n4 = dimension.height - 1;
        int n5 = 1;
        while (n5 <= this.selectionBorderThickness) {
            graphics.draw3DRect(n, n2, n3, n4, false);
            ++n;
            ++n2;
            n3 -= 2;
            n4 -= 2;
            ++n5;
        }
    }

    public Color getSelectionBorderColor() {
        Color color = selectionBorderColor == null ? this.getBackground() : selectionBorderColor;
        return color;
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.setHidden(true);
        this.sizeTo(this.comp, this.getParent());
        this.setHidden(false);
    }

    public void componentMoved(ComponentEvent componentEvent) {
        this.setHidden(true);
        this.sizeTo(this.comp, this.getParent());
        this.setHidden(false);
    }

    public void componentShown(ComponentEvent componentEvent) {
        if (this.uninitialized) {
            this.sizeTo(this.comp, this.getParent());
        }
        if (!this.uninitialized) {
            this.setHidden(false);
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
        this.setHidden(true);
    }
}

